/*== MT8820 Radio Communication Analyzer ===============*/
/*    Modification History: 
   12 Oct 2002 changed by Usami 
   17 Jan 2003 changed by Scott 
   25 Jul 2003 - [V3.0], Anritsu MCA1, New Released 
   01 Sep 2003 - [V3.1], Anritsu MCA1, Deleted:INILEVEL?/MCAT?/MCFV?/MSTAT?

*/
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/

#ifndef  __MT8820_HEADER_MF
#define __MT8820_HEADER_MF

#include <visatype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/

#define VI_ERROR_FILE_OPEN              (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_FILE_WRITE             (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_SECURITY_CODE          (_VI_ERROR+0x3FFC0802L)
#define VI_ERROR_INTERPRETING_RESPONSE  (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_STAMP                  (_VI_ERROR+0x3FFC0805L)
#define VI_ERROR_OUTOF_RANGE            (_VI_ERROR+0x3FFC0806L)

/*****************************************************************************/
/*= Define Other useful values here             =============================*/
/*****************************************************************************/

#define BUFFER_SIZE     256L         /* File I/O buffer size */
#define SMALL_BUFFER BUFFER_SIZE - 1 /* I/O buffer for Scan function */
#define LARGE_BUFFER_SIZE     4096L         /* File I/O buffer size */
#define LARGE_BUFFER_M1 LARGE_BUFFER_SIZE - 1 /* I/O buffer for Scan function */
#define MAX_CMD_LENGTH  256L
#define AUMT8820_FREQUENCY_UNIT_HZ   0
#define AUMT8820_FREQUENCY_UNIT_KHZ  1
#define AUMT8820_FREQUENCY_UNIT_MHZ  2
#define AUMT8820_FREQUENCY_UNIT_GHZ  3
#define HZ   0
#define KHZ  1
#define MHZ  2
#define GHZ  3

/*****************************************************************************/
/*= Define Enumeration Constants here             ===========================*/
/*****************************************************************************/

/*****************************************************************************/
/*					            Main Frame
		      The following values are defined for Main Frame 				 */
/*****************************************************************************/		
#define AUMT8820_FREQUENCY_UNIT_HZ   0
#define AUMT8820_FREQUENCY_UNIT_KHZ  1
#define AUMT8820_FREQUENCY_UNIT_MHZ  2
#define AUMT8820_FREQUENCY_UNIT_GHZ  3

#define AUMT8820_ESE_MASK_B0_OPERATION_COMPLETE 1
#define AUMT8820_ESE_MASK_B1_REQUEST_CONTROL    2
#define AUMT8820_ESE_MASK_B2_QUERY_ERROR        4
#define AUMT8820_ESE_MASK_B3_DEVICE_ERROR       8
#define AUMT8820_ESE_MASK_B4_EXECUTION_ERROR    16
#define AUMT8820_ESE_MASK_B5_COMMAND_ERROR      32
#define AUMT8820_ESE_MASK_B6_USER_REQUEST       64
#define AUMT8820_ESE_MASK_B7_POWER_ON           128

#define AUMT8820_STB_MASK_B0_NOT_USED    1
#define AUMT8820_STB_MASK_B1_NOT_USED    2
#define AUMT8820_STB_MASK_B2_ERR_EVENT   4
#define AUMT8820_STB_MASK_B3_END_EVENT   8
#define AUMT8820_STB_MASK_B4_MAV         16
#define AUMT8820_STB_MASK_B5_ESB         32
#define AUMT8820_STB_MASK_B6_MSS_OR_RQS  64
#define AUMT8820_STB_MASK_B7_NOT_USED    128

#define AUMT8820_ESE2_MASK_B0_MEASUREMENT_COMPLETE 1
#define AUMT8820_ESE2_MASK_B1_NOT_USED             2
#define AUMT8820_ESE2_MASK_B2_NOT_USED             4
#define AUMT8820_ESE2_MASK_B3_NOT_USED             8
#define AUMT8820_ESE2_MASK_B4_NOT_USED             16
#define AUMT8820_ESE2_MASK_B5_NOT_USED             32
#define AUMT8820_ESE2_MASK_B6_NOT_USED             64
#define AUMT8820_ESE2_MASK_B7_NOT_USED             128

#define AUMT8820_ESE3_MASK_B0_SYNCHRONIZATION_LOSS  1
#define AUMT8820_ESE3_MASK_B1_NOT_USED              2
#define AUMT8820_ESE3_MASK_B2_TX_MEASUREMENT_ERROR  4
#define AUMT8820_ESE3_MASK_B3_RX_MEASUREMENT_ERROR  8
#define AUMT8820_ESE3_MASK_B4_CALL_PROCESSING_ERROR 16
#define AUMT8820_ESE3_MASK_B5_NOT_USED              32
#define AUMT8820_ESE3_MASK_B6_CALL_DROP_ERROR       64
#define AUMT8820_ESE3_MASK_B7_NOT_USED              128

#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_COMPLETED      0
#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_EXECUTING      1

#define AUMT8820_MEASUREMENT_STATUS_NORMAL_END             0
#define AUMT8820_MEASUREMENT_STATUS_1_UNDEFINED            1
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_OVER             2
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_UNDER            3
#define AUMT8820_MEASUREMENT_STATUS_MEAS_DISABLE           4
#define AUMT8820_MEASUREMENT_STATUS_SYNC_WORD_DET_DISABLE  5
#define AUMT8820_MEASUREMENT_STATUS_SYNC_ESTABLISHING      6
#define AUMT8820_MEASUREMENT_STATUS_SYNC_ERROR             7
#define AUMT8820_MEASUREMENT_STATUS_8_UNDEFINED            8
#define AUMT8820_MEASUREMENT_STATUS_NOT_MEASURED           9
#define AUMT8820_MEASUREMENT_STATUS_10_UNDEFINED           10
#define AUMT8820_MEASUREMENT_STATUS_11_UNDEFINED           11
#define AUMT8820_MEASUREMENT_STATUS_TX_MEAS_TIMEOUT        12
#define AUMT8820_MEASUREMENT_STATUS_RX_MEAS_TIMEOUT        13

#define AUMT8820_OPERATION_COMPLETE_COMPLETED      1
#define AUMT8820_OPERATION_COMPLETE_EXECUTING      0

#define AUMT8820_SCREEN_MODE_ON      0
#define AUMT8820_SCREEN_MODE_OFF     1

#define AUMT8820_TEST_RESULT_NORMAL_END      0
#define AUMT8820_TEST_RESULT_ERROR           1

#define AUMT8820_ALARM_SOUND_MODE_ON      0
#define AUMT8820_ALARM_SOUND_MODE_OFF     1

#define AUMT8820_DATE_MODE_YYYY_MM_DD      0
#define AUMT8820_DATE_MODE_MM_DD_YYYY      1
#define AUMT8820_DATE_MODE_DD_MM_YYYY      2

#define AUMT8820_PANEL_DISPLAY_MODE_ON      0
#define AUMT8820_PANEL_DISPLAY_MODE_OFF     1

#define AUMT8820_INITIALIZATION_LEVEL_INSTRUMENT    0
#define AUMT8820_INITIALIZATION_LEVEL_FACTORYF      1
#define AUMT8820_INITIALIZATION_LEVEL_SYSTEM        2
#define AUMT8820_INITIALIZATION_LEVEL_POWER_ON      3

#define AUMT8820_SOFTWARE_OBJECT_IPL          0
#define AUMT8820_SOFTWARE_OBJECT_MAIN_FRAME   1
#define AUMT8820_SOFTWARE_OBJECT_PREBOOT      2
#define AUMT8820_SOFTWARE_OBJECT_PLATFORM     3


#define AUMT8820_PRESET_TO_INITIALIZATION_LEVEL_SYSTEM      0
#define AUMT8820_PRESET_TO_INITIALIZATION_LEVEL_INSTRUMENT  1
#define AUMT8820_PRESET_TO_INITIALIZATION_LEVEL_FACTORY     2
#define AUMT8820_PRESET_TO_INITIALIZATION_LEVEL_POWER_ON    3

#define AUMT8820_REFERENCE_FREQUENCY_10_MHZ_INTERNAL      0
#define AUMT8820_REFERENCE_FREQUENCY_10_MHZ_EXTERNAL      1
#define AUMT8820_REFERENCE_FREQUENCY_13_MHZ_EXTERNAL      2

#define AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_MAIN_IN_OUT_CONNECTOR     0
#define AUMT8820_RF_SIGANL_OUTPUT_CONNECTOR_AUX_OUTPUT_CONNECTOR      1

#define AUMT8820_SCREEN_SELECT_FUNDAMENTAL_MEAS      0
#define AUMT8820_SCREEN_SELECT_PARAMETER_SAVE        1
#define AUMT8820_SCREEN_SELECT_PARAMETER_RECALL      2
#define AUMT8820_SCREEN_SELECT_SYSTEM_CONFIGURATION  3
#define AUMT8820_SCREEN_SELECT_SYSTEM_INFORMATION    4

#define AUMT8820_STANDARD_SELECT_WCDMA    0
#define AUMT8820_STANDARD_SELECT_GSM      1

#define AUMT8820_WINDOW_SETUP_PARAMETERS           0
#define AUMT8820_WINDOW_FUNDAMENTAL_MEASUREMENT    1
#define AUMT8820_WINDOW_MS_REPORT                  2
#define AUMT8820_WINDOW_SYSTEM_CONFIGURATION       3

#define AUMT8820_TAG_SETUP_PARAMETERS_COMMON               0
#define AUMT8820_TAG_SETUP_PARAMETERS_AUDIO                1
#define AUMT8820_TAG_SETUP_PARAMETERS_CALL_PROCESSING      2
#define AUMT8820_TAG_SETUP_PARAMETERS_TX_MEASUREMENT       3
#define AUMT8820_TAG_SETUP_PARAMETERS_RX_MEASUREMENT       4
#define AUMT8820_TAG_SETUP_PARAMETERS_FUNDAMENTAL_MEAS     5
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_POWER_MEAS    6
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_POWER_VS_TIME 7
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_TEMPLATE      8
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_MOD_ANAL      9
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_RF_MOD        10
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_RF_SWITCH     11
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_BER           12
#define AUMT8820_TAG_FUNDAMENTAL_MEASUREMENT_BLER          13
#define AUMT8820_TAG_MS_REPORT_MS_REPORT                   14
#define AUMT8820_TAG_SYSTEM_CONFIGURATION_COMMON           15
#define AUMT8820_TAG_SYSTEM_CONFIGURATION_PHONE1           16

#define AUMT8820_GPIB_TERMINATOR_LF      0
#define AUMT8820_GPIB_TERMINATOR_CR_LF   1

#define AUMT8820_TITLE_DISPLAY_TYPE_USER_TITLE      0
#define AUMT8820_TITLE_DISPLAY_TYPE_DATE_AND_TIME   1
#define AUMT8820_TITLE_DISPLAY_TYPE_NO_DISPLAY      2

//#error In MainFrame!
/*****************************************************************************/
/*= Define Function Prototypes here             =============================*/
/*****************************************************************************/

/*****************************************************************************/
/*					            Main Frame
		      The following functions are defined for Main Frame 			 */
/*****************************************************************************/		
ViStatus _VI_FUNC AuMT8820_Clear_Status(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Close(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Continuous_Sweep_Mode(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Go_To_Local(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Init(ViRsrc resourceName, ViBoolean IDQuery,  ViBoolean ResetInstr, ViSession *instrSession);
ViStatus _VI_FUNC AuMT8820_Preset_To_System_Initialization(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Preset_To_Initialization_Level(ViSession instrSession, ViInt32 initialization_Level);
ViStatus _VI_FUNC AuMT8820_Reset(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Reset_To_Default(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Revision(ViSession instrSession, ViChar _VI_FAR driverRev[], ViChar _VI_FAR instrRev[]);
ViStatus _VI_FUNC AuMT8820_Single_Sweep_Mode(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Stop_Measurement(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Sound_Buzzer(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Trigger(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Wait_To_Continue(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Set_Alarm_Sound_Mode(ViSession instrSession, ViInt32 sound);
ViStatus _VI_FUNC AuMT8820_Get_Alarm_Sound_Mode(ViSession instrSession,  ViInt32  _VI_FAR *sound);
ViStatus _VI_FUNC AuMT8820_Set_Date(ViSession instrSession, ViInt32 year, ViInt32 month, ViInt32 day);
ViStatus _VI_FUNC AuMT8820_Get_Date(ViSession instrSession, ViInt32 _VI_FAR *year, ViInt32 _VI_FAR *month, ViInt32 _VI_FAR *day);
ViStatus _VI_FUNC AuMT8820_Set_Date_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Date_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_END_Event_Status_Enable_Register(ViSession instrSession, ViInt32 SEregister);
ViStatus _VI_FUNC AuMT8820_Get_END_Event_Status_Enable_Register(ViSession instrSession, ViInt32 _VI_FAR *SEregister);
ViStatus _VI_FUNC AuMT8820_Get_END_Event_Status_Register_Query(ViSession instrSession, ViInt32 _VI_FAR *event_Status);
ViStatus _VI_FUNC AuMT8820_Set_ERR_Event_Status_Enable_Register(ViSession instrSession, ViInt32 SEregister);
ViStatus _VI_FUNC AuMT8820_Get_ERR_Event_Status_Enable_Register(ViSession instrSession, ViInt32 _VI_FAR *SEregister);
ViStatus _VI_FUNC AuMT8820_Get_ERR_Event_Status_Register_Query(ViSession instrSession, ViInt32 _VI_FAR *event_Status);
ViStatus _VI_FUNC AuMT8820_Get_Full_Calibration_Time(ViSession instrSession, ViInt32 _VI_FAR *year,ViInt32 _VI_FAR *month, ViInt32 _VI_FAR *day, ViInt32 _VI_FAR *hours, ViInt32 _VI_FAR *minutes, ViInt32 _VI_FAR *seconds);
ViStatus _VI_FUNC AuMT8820_Set_GPIB_Terminator(ViSession instrSession, ViInt32 terminator);
ViStatus _VI_FUNC AuMT8820_Get_GPIB_Terminator(ViSession instrSession,  ViInt32  _VI_FAR *terminator);
ViStatus _VI_FUNC AuMT8820_Get_Identify_Query(ViSession instrSession, ViChar _VI_FAR string[]);
ViStatus _VI_FUNC AuMT8820_Set_Operation_Complete(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Get_Operation_Complete(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Panel_Display_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Panel_Display_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Default_Filename_Query(ViSession instrSession, ViChar _VI_FAR default_Name[]);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Directory_Query(ViSession instrSession, ViChar _VI_FAR directory[]);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Read_Directory_List(ViSession instrSession, ViChar _VI_FAR read_Files[]);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Save_Directory_Query(ViSession instrSession, ViChar _VI_FAR save_Directory[]);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Save_Directory_List(ViSession instrSession, ViChar _VI_FAR file_List[]);
ViStatus _VI_FUNC AuMT8820_Get_Parameters_By_Name(ViSession instrSession, ViChar _VI_FAR file_Name[]);
ViStatus _VI_FUNC AuMT8820_Set_Parameters_By_Name(ViSession instrSession, ViChar _VI_FAR file_Name[]);
ViStatus _VI_FUNC AuMT8820_Set_Parameters_By_Next_Number(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Set_Parameters_By_Number(ViSession instrSession, ViInt32 file_Number);
ViStatus _VI_FUNC AuMT8820_Get_Parameters_By_Number(ViSession instrSession, ViInt32 file_Number);
ViStatus _VI_FUNC AuMT8820_Get_Power_On_Time(ViSession instrSession, ViInt32 _VI_FAR *accumulated_Time);
ViStatus _VI_FUNC AuMT8820_Set_Reference_Frequency(ViSession instrSession, ViInt32 frequency);
ViStatus _VI_FUNC AuMT8820_Get_Reference_Frequency(ViSession instrSession,  ViInt32  _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Set_RF_Signal_Output_Connector(ViSession instrSession, ViInt32 connector);
ViStatus _VI_FUNC AuMT8820_Get_RF_Signal_Output_Connector(ViSession instrSession,  ViInt32  _VI_FAR *connector);
ViStatus _VI_FUNC AuMT8820_Set_Screen_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Self_Test(ViSession instrSession, ViInt32 _VI_FAR *test_result);
ViStatus _VI_FUNC AuMT8820_Get_Serial_Number_Query(ViSession instrSession, ViChar _VI_FAR serial_Number[]);
ViStatus _VI_FUNC AuMT8820_Set_Service_Request_Enable(ViSession instrSession, ViInt32 mask);
ViStatus _VI_FUNC AuMT8820_Get_Service_Request_Enable(ViSession instrSession, ViInt32 _VI_FAR *mask);
ViStatus _VI_FUNC AuMT8820_Set_Standard_Event_Status_Enable(ViSession instrSession, ViInt32 mask);
ViStatus _VI_FUNC AuMT8820_Get_Standard_Event_Status_Enable(ViSession instrSession, ViInt32 _VI_FAR *mask);
ViStatus _VI_FUNC AuMT8820_Get_Standard_Event_Status_Register_Query(ViSession instrSession, ViInt32 _VI_FAR *value);
ViStatus _VI_FUNC AuMT8820_Set_Standard_Select(ViSession instrSession, ViInt32 standard);
ViStatus _VI_FUNC AuMT8820_Get_Standard_Select(ViSession instrSession,  ViInt32  _VI_FAR *standard);
ViStatus _VI_FUNC AuMT8820_Get_Status_Byte_Query(ViSession instrSession, ViInt32 _VI_FAR *value);
ViStatus _VI_FUNC AuMT8820_Set_Synchronous_Single_Sweep(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Get_Synchronous_Single_Sweep(ViSession instrSession,  ViInt32  _VI_FAR *mode);
//ViStatus _VI_FUNC AuMT8820_Get_Switching_Count(ViSession instrSession, ViChar _VI_FAR switching_Count_Status[]);
ViStatus _VI_FUNC AuMT8820_Set_Time(ViSession instrSession, ViInt32 hours, ViInt32 minutes, ViInt32 seconds);
ViStatus _VI_FUNC AuMT8820_Get_Time(ViSession instrSession, ViInt32 _VI_FAR *hours, ViInt32 _VI_FAR *minutes, ViInt32 _VI_FAR *seconds);
ViStatus _VI_FUNC AuMT8820_Set_Title_Display_Type(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Title_Display_Type(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_User_Title(ViSession instrSession, ViChar _VI_FAR title[]);
ViStatus _VI_FUNC AuMT8820_Get_User_Title(ViSession instrSession, ViChar _VI_FAR title[]);

/*****************************************************************************/
/*= UTILITY ROUTINE DECLARATIONS  ===========================================*/
/*****************************************************************************/
ViBoolean AuMT8820_InvalidViBooleanRange(ViBoolean val);
ViBoolean AuMT8820_InvalidViInt8Range(ViInt8 val, ViInt8 min, ViInt8 max);
ViBoolean AuMT8820_InvalidViInt16Range(ViInt16 val, ViInt16 min, ViInt16 max);
ViBoolean AuMT8820_InvalidViInt32Range(ViInt32 val, ViInt32 min, ViInt32 max);
ViBoolean AuMT8820_InvalidViUInt8Range(ViUInt8 val, ViUInt8 min, ViUInt8 max);
ViBoolean AuMT8820_InvalidViUInt16Range(ViUInt16 val, ViUInt16 min, ViUInt16 max);
ViBoolean AuMT8820_InvalidViUInt32Range(ViUInt32 val, ViUInt32 min, ViUInt32 max);
ViBoolean AuMT8820_InvalidViReal32Range(ViReal32 val, ViReal32 min, ViReal32 max);
ViBoolean AuMT8820_InvalidViReal64Range(ViReal64 val, ViReal64 min, ViReal64 max);
ViStatus AuMT8820_InitCleanUp(ViSession openRMSession, ViPSession openInstrSession, ViStatus currentStatus);
ViStatus AuMT8820_Write(ViSession instrSession, ViChar *buf, ViUInt32 cnt, ViUInt32 *retCnt);
ViStatus AuMT8820_Read(ViSession instrSession, ViChar *buf, ViUInt32 cnt, ViUInt32 *retCnt);
ViStatus AuMT8820_StringToEnum(ViChar **enumStrings, ViChar *targetString, ViUInt32 *index);
ViReal64 AuMT8820_CoerceFloatToStep(ViReal64 valueToCoerce, ViReal64 stepSize);
ViUInt32 AuMT8820_CoerceIntToStep(ViUInt32 valueToCoerce, ViUInt32 stepSize);
ViStatus AuMT8820_DefaultInstrSetup(ViSession instrSession);
ViStatus AuMT8820_ParseStrings(ViChar *buffer, ViChar **destStrings);
void AuMT8820_IntegerToAsciiBitString(ViUInt32 integer, ViChar *asciiBitString, ViUInt32 stringSize);
ViUInt32 AuMT8820_AsciiBitStringToInteger(ViChar *asciiBitString);



#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
